/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.Elastane;
import net.sourceforge.plantuml.graph.EntityImageFactory;
import net.sourceforge.plantuml.graph.Galaxy4;
import net.sourceforge.plantuml.graphic.StringBounderUtils;

public class Graph2 {
    private static final Graphics2D dummyGraphics2D;
    private final Elastane elastane;
    private int widthCell;
    private int heightCell;

    public Graph2(Board board) {
        board.normalize();
        for (ANode aNode : board.getNodes()) {
            Dimension2D dim = this.images(aNode).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D));
            this.widthCell = Math.max(this.widthCell, (int)dim.getWidth());
            this.heightCell = Math.max(this.heightCell, (int)dim.getHeight());
        }
        Galaxy4 galaxy = new Galaxy4(board, this.widthCell, this.heightCell);
        this.elastane = new Elastane(galaxy);
        for (ANode n : board.getNodes()) {
            Dimension2D dimension2D = this.images(n).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D));
            this.elastane.addBox(n, (int)dimension2D.getWidth(), (int)dimension2D.getHeight());
        }
        ArrayList<? extends ALink> arrayList = new ArrayList<ALink>(board.getLinks());
        Collections.sort(arrayList, board.getLinkComparator());
        for (ALink aLink : arrayList) {
            galaxy.addLink(aLink);
        }
        this.elastane.init();
    }

    private AbstractEntityImage images(ANode n) {
        return new EntityImageFactory().createEntityImage((IEntity)n.getUserData());
    }

    public Dimension2D getDimension() {
        return this.elastane.getDimension();
    }

    public void draw(Graphics2D g2d) {
        this.elastane.draw(g2d);
    }

    static {
        EmptyImageBuilder builder = new EmptyImageBuilder(10, 10, Color.WHITE);
        dummyGraphics2D = builder.getGraphics2D();
    }
}

